//
//  RMFTPClient.h
//  RMFTP
//
//  Created by Tom Bradley on 18/04/2016.
//  Copyright © 2016 Realmac Software. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>

#import "RMFTP-Constants.h"

@class RMFTPAvailableServerFeatures;
@class RMFTPURLCredential;
@class RMFTPUploadFileOperation;
@class RMFTPUploadFilesOperation;

@interface RMFTPClient : NSObject

@property (nonatomic, readonly) NSError *lastError;

@property (nonatomic, readonly) BOOL isFTP;
@property (nonatomic, readonly) BOOL isFTPS;
@property (nonatomic, readonly) BOOL isSFTP;
@property (nonatomic, readonly) BOOL isLocal;
@property (nonatomic, readonly) BOOL isS3;

@property (nonatomic, readonly, getter=isConnected) BOOL connected;
@property (nonatomic, readonly) NSURL *serverURL;

@property (nonatomic, assign) BOOL ignoreCertificateErrors;
@property (nonatomic, assign) RMCurlConnectionType connectionType;
@property (nonatomic, assign) RMCurlURLConnectionMode connectionMode;
@property (nonatomic, assign) RMCurlSSLMode sslMode;

- (void)connectAndFetchAvailableFeaturesWithCompletionHandler:(void (^)(NSError *error, RMFTPAvailableServerFeatures *availableFeatures))completionHandler;

- (instancetype)initWithServerURL:(NSURL *)serverURL credentials:(RMFTPURLCredential *)credential maxConnections:(NSUInteger)maximumConnections;

- (void)connectWithCompletionHandler:(void (^)(NSError *error))completionHandler;
- (void)disconnect;
- (void)shutdown;

- (void)absolutePathAtPath:(NSString *)path completionHandler:(void (^)(NSString *absolutePath, NSError *error))completionHandler;
- (void)listDirectoryContentsAtPath:(NSString *)path completionHandler:(void (^)(NSString *absolutePath, NSArray *directories, NSArray *files, NSError *error))completionHandler;
- (void)createDirectoryAtPath:(NSString *)path named:(NSString *)directoryName completionHandler:(void (^)(NSError *error))completionHandler;
- (void)deleteFileAtPath:(NSString *)path isDirectory:(BOOL)isDirectory completionHandler:(void (^)(NSError *error))completionHandler;
- (void)downloadFileAtPath:(NSString *)path toPath:(NSString *)localPath completionHandler:(void (^)(NSError *error))completionHandler;

- (RMFTPUploadFileOperation *)newUploadFileOperationWithlocalFileURL:(NSURL *)localFileURL toPath:(NSString *)path;
- (RMFTPUploadFileOperation *)newUploadFileOperationWithLocalFileURL:(NSURL *)localFileURL destinationFilename:(NSString *)destinationFilename toPath:(NSString *)path renameAfterUpload:(BOOL)renameAfterUpload;

- (RMFTPUploadFilesOperation *)newUploadFilesOperationFromLocalBaseURL:(NSURL *)localBaseURL filePaths:(NSArray *)filePaths toPath:(NSString *)path;

@end
